class NewRoundMessage extends CriticalEventPlus;

#exec Audio Import File="Sounds\NewRoundIn.wav" Name="NewRoundIn"

var localized String StartMsg1;
var localized String StartMsg2;
var Sound NextWaveIn;

static function string GetString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
) 
{
	return Default.StartMsg1@Switch@Default.StartMsg2;
}

static simulated function ClientReceive( 
	PlayerPawn P,
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
) 
{
	Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
	P.ClientPlaySound(Default.NextWaveIn, , true);

}

defaultproperties
{
    StartMsg1="Round"
    StartMsg2="- Get Ready!"
    NextWaveIn=Sound'NewRoundIn'
    bBeep=False
}
